// Copyright 1994, 1995 by Jon Dart.  All Rights Reserved.

#include "stdafx.h"
#include "searchop.h"
#include "constant.h"

Search_Limit_Options::Search_Limit_Options()
{
}

Search_Limit_Options::Search_Limit_Options( const Time_Control &tc,
  const Control c )
{
    const Search_Limit limit = tc.get_search_limit();
    char tmp[20];
    switch (tc.get_search_type())
    {
        case Fixed_Ply:
           search_type = 0;
           wsprintf(tmp,"%d",
             limit.max_ply);
	   move_or_ply = tmp;
           time_limit = "";
           break;
        case Time_Limit:
           search_type = (c == First) ? 1 : 0;
           wsprintf(tmp,"%ld",
              limit.seconds);
           move_or_ply = tmp;
           time_limit = "";
           break;
        case Game:
           search_type = (c == First) ? 2 : 1;
           wsprintf(tmp,"%d",
              limit.limit.minutes);
           move_or_ply = tmp;
           time_limit = "";
           break;
        case Tournament:
           search_type = (c == First) ? 3 : 2;
           wsprintf(tmp,"%d",
              limit.limit.moves);
           move_or_ply = tmp;
           wsprintf(tmp,"%d",
              limit.limit.minutes);
           time_limit = tmp;
           break;
       case Time_Target: // not used in GUI
           break;
       case None:
           search_type = (c == First) ? 4 : 0;
           time_limit = "";
	   move_or_ply = "";
           break;
    }
}

BOOL Search_Limit_Options::parse(Time_Control &tc, const Control c)
{
     int minutes, moves;
     Search_Limit limit;
     int index = search_type;
     // The buttons in the search limit dialogs do not correspond
     // directly to the enum Search_Type.  So compensate for that here:
     if (c == First)
     {
         static int indexes[] = { 0, 1, 3, 4, 0 };
         index = indexes[search_type];
     }
     if (c == Second)
     {
         static int indexes[] = { 5, 3, 4, 0, 0 };
         index = indexes[search_type];
     }
     switch (index)
     {
        case 0: /* Fixed_Ply */
           limit.max_ply = atoi((LPCSTR)move_or_ply);
           if (limit.max_ply <= 0) limit.max_ply = 2;
           if (limit.max_ply > Constants::MaxPly) 
              limit.max_ply = Constants::MaxPly;
           break;
       case 1: /* Time_Limit */
           {
           unsigned long seconds = atol((LPCSTR)move_or_ply);
           limit.seconds = seconds;
           break;
           }
       case 2: /* Time Target */
           // not used in GUI
           break;
       case 3: /* Game */
           {
           int minutes = atoi((LPCSTR)move_or_ply);
           limit.limit.minutes = minutes;
           break;
           }
       case 4: /* Tournament */
           moves = atoi(move_or_ply);
           minutes = atoi(time_limit);
           if (moves && minutes)
           {
              limit.limit.moves = moves;
              limit.limit.minutes = minutes;
          }
          break;
     }
     tc.set_search_type((Search_Type)index);
     tc.set_search_limit(limit);
     return TRUE;
}

int Search_Limit_Options::operator == (const Search_Limit_Options &opts) const
{
   return (search_type == opts.search_type &&
           move_or_ply == opts.move_or_ply &&
           time_limit == opts.time_limit);
}

int Search_Limit_Options::operator != (const Search_Limit_Options &opts) const
{
   return (search_type != opts.search_type ||
           move_or_ply != opts.move_or_ply ||
           time_limit != opts.time_limit);
}
   
